package zio.aws.globalaccelerator.model
import zio.aws.globalaccelerator.model.primitives.{
  GenericBoolean,
  EndpointWeight,
  GenericString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EndpointConfiguration(
    endpointId: Optional[GenericString] = Optional.Absent,
    weight: Optional[EndpointWeight] = Optional.Absent,
    clientIPPreservationEnabled: Optional[GenericBoolean] = Optional.Absent,
    attachmentArn: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration = {
    import EndpointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration
      .builder()
      .optionallyWith(endpointId.map(value => value: java.lang.String))(
        _.endpointId
      )
      .optionallyWith(
        weight.map(value => EndpointWeight.unwrap(value): Integer)
      )(_.weight)
      .optionallyWith(
        clientIPPreservationEnabled.map(value => value: java.lang.Boolean)
      )(_.clientIPPreservationEnabled)
      .optionallyWith(attachmentArn.map(value => value: java.lang.String))(
        _.attachmentArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.EndpointConfiguration.ReadOnly =
    zio.aws.globalaccelerator.model.EndpointConfiguration.wrap(buildAwsValue())
}
object EndpointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.EndpointConfiguration =
      zio.aws.globalaccelerator.model.EndpointConfiguration(
        endpointId.map(value => value),
        weight.map(value => value),
        clientIPPreservationEnabled.map(value => value),
        attachmentArn.map(value => value)
      )
    def endpointId: Optional[GenericString]
    def weight: Optional[EndpointWeight]
    def clientIPPreservationEnabled: Optional[GenericBoolean]
    def attachmentArn: Optional[GenericString]
    def getEndpointId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointId", endpointId)
    def getWeight: ZIO[Any, AwsError, EndpointWeight] =
      AwsError.unwrapOptionField("weight", weight)
    def getClientIPPreservationEnabled: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField(
        "clientIPPreservationEnabled",
        clientIPPreservationEnabled
      )
    def getAttachmentArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("attachmentArn", attachmentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration
  ) extends zio.aws.globalaccelerator.model.EndpointConfiguration.ReadOnly {
    override val endpointId: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointId())
      .map(value => value: GenericString)
    override val weight: Optional[EndpointWeight] = zio.aws.core.internal
      .optionalFromNullable(impl.weight())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.EndpointWeight(value)
      )
    override val clientIPPreservationEnabled: Optional[GenericBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientIPPreservationEnabled())
        .map(value => value: GenericBoolean)
    override val attachmentArn: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentArn())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration
  ): zio.aws.globalaccelerator.model.EndpointConfiguration.ReadOnly =
    new Wrapper(impl)
}
