package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DescribeEndpointGroupRequest(endpointGroupArn: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest = {
    import DescribeEndpointGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest
      .builder()
      .endpointGroupArn(endpointGroupArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeEndpointGroupRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeEndpointGroupRequest
      .wrap(buildAwsValue())
}
object DescribeEndpointGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeEndpointGroupRequest =
      zio.aws.globalaccelerator.model
        .DescribeEndpointGroupRequest(endpointGroupArn)
    def endpointGroupArn: GenericString
    def getEndpointGroupArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest
  ) extends zio.aws.globalaccelerator.model.DescribeEndpointGroupRequest.ReadOnly {
    override val endpointGroupArn: GenericString =
      impl.endpointGroupArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest
  ): zio.aws.globalaccelerator.model.DescribeEndpointGroupRequest.ReadOnly =
    new Wrapper(impl)
}
