package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCrossAccountAttachmentResponse(
    crossAccountAttachment: Optional[
      zio.aws.globalaccelerator.model.Attachment
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentResponse = {
    import DescribeCrossAccountAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentResponse
      .builder()
      .optionallyWith(
        crossAccountAttachment.map(value => value.buildAwsValue())
      )(_.crossAccountAttachment)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeCrossAccountAttachmentResponse.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeCrossAccountAttachmentResponse
      .wrap(buildAwsValue())
}
object DescribeCrossAccountAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeCrossAccountAttachmentResponse =
      zio.aws.globalaccelerator.model.DescribeCrossAccountAttachmentResponse(
        crossAccountAttachment.map(value => value.asEditable)
      )
    def crossAccountAttachment
        : Optional[zio.aws.globalaccelerator.model.Attachment.ReadOnly]
    def getCrossAccountAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.Attachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "crossAccountAttachment",
      crossAccountAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentResponse
  ) extends zio.aws.globalaccelerator.model.DescribeCrossAccountAttachmentResponse.ReadOnly {
    override val crossAccountAttachment
        : Optional[zio.aws.globalaccelerator.model.Attachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crossAccountAttachment())
        .map(value => zio.aws.globalaccelerator.model.Attachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentResponse
  ): zio.aws.globalaccelerator.model.DescribeCrossAccountAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
