package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCrossAccountAttachmentResponse(
    crossAccountAttachment: Optional[
      zio.aws.globalaccelerator.model.Attachment
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentResponse = {
    import CreateCrossAccountAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentResponse
      .builder()
      .optionallyWith(
        crossAccountAttachment.map(value => value.buildAwsValue())
      )(_.crossAccountAttachment)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CreateCrossAccountAttachmentResponse.ReadOnly =
    zio.aws.globalaccelerator.model.CreateCrossAccountAttachmentResponse
      .wrap(buildAwsValue())
}
object CreateCrossAccountAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.CreateCrossAccountAttachmentResponse =
      zio.aws.globalaccelerator.model.CreateCrossAccountAttachmentResponse(
        crossAccountAttachment.map(value => value.asEditable)
      )
    def crossAccountAttachment
        : Optional[zio.aws.globalaccelerator.model.Attachment.ReadOnly]
    def getCrossAccountAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.Attachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "crossAccountAttachment",
      crossAccountAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentResponse
  ) extends zio.aws.globalaccelerator.model.CreateCrossAccountAttachmentResponse.ReadOnly {
    override val crossAccountAttachment
        : Optional[zio.aws.globalaccelerator.model.Attachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crossAccountAttachment())
        .map(value => zio.aws.globalaccelerator.model.Attachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentResponse
  ): zio.aws.globalaccelerator.model.CreateCrossAccountAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
