package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class Resource(
    endpointId: GenericString,
    region: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.Resource
      .builder()
      .endpointId(endpointId: java.lang.String)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.Resource.ReadOnly =
    zio.aws.globalaccelerator.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.Resource =
      zio.aws.globalaccelerator.model
        .Resource(endpointId, region.map(value => value))
    def endpointId: GenericString
    def region: Optional[GenericString]
    def getEndpointId: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointId)
    def getRegion: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.Resource
  ) extends zio.aws.globalaccelerator.model.Resource.ReadOnly {
    override val endpointId: GenericString = impl.endpointId(): GenericString
    override val region: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.Resource
  ): zio.aws.globalaccelerator.model.Resource.ReadOnly = new Wrapper(impl)
}
