package zio.aws.globalaccelerator.model
import zio.aws.globalaccelerator.model.primitives.{MaxResults, GenericString}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingEndpointGroupsRequest(
    listenerArn: GenericString,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest = {
    import ListCustomRoutingEndpointGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
      .builder()
      .listenerArn(listenerArn: java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
      .wrap(buildAwsValue())
}
object ListCustomRoutingEndpointGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest =
      zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest(
        listenerArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def listenerArn: GenericString
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[GenericString]
    def getListenerArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(listenerArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest.ReadOnly {
    override val listenerArn: GenericString = impl.listenerArn(): GenericString
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
  ): zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
