package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListCrossAccountResourcesResponse(
    crossAccountResources: Optional[
      Iterable[zio.aws.globalaccelerator.model.CrossAccountResource]
    ] = Optional.Absent,
    nextToken: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesResponse = {
    import ListCrossAccountResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesResponse
      .builder()
      .optionallyWith(
        crossAccountResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.crossAccountResources)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCrossAccountResourcesResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListCrossAccountResourcesResponse
      .wrap(buildAwsValue())
}
object ListCrossAccountResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCrossAccountResourcesResponse =
      zio.aws.globalaccelerator.model.ListCrossAccountResourcesResponse(
        crossAccountResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def crossAccountResources: Optional[
      List[zio.aws.globalaccelerator.model.CrossAccountResource.ReadOnly]
    ]
    def nextToken: Optional[GenericString]
    def getCrossAccountResources: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CrossAccountResource.ReadOnly
    ]] =
      AwsError.unwrapOptionField("crossAccountResources", crossAccountResources)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesResponse
  ) extends zio.aws.globalaccelerator.model.ListCrossAccountResourcesResponse.ReadOnly {
    override val crossAccountResources: Optional[
      List[zio.aws.globalaccelerator.model.CrossAccountResource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.crossAccountResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.CrossAccountResource.wrap(item)
        }.toList
      )
    override val nextToken: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesResponse
  ): zio.aws.globalaccelerator.model.ListCrossAccountResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
