package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListCrossAccountAttachmentsResponse(
    crossAccountAttachments: Optional[
      Iterable[zio.aws.globalaccelerator.model.Attachment]
    ] = Optional.Absent,
    nextToken: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsResponse = {
    import ListCrossAccountAttachmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsResponse
      .builder()
      .optionallyWith(
        crossAccountAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.crossAccountAttachments)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCrossAccountAttachmentsResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListCrossAccountAttachmentsResponse
      .wrap(buildAwsValue())
}
object ListCrossAccountAttachmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCrossAccountAttachmentsResponse =
      zio.aws.globalaccelerator.model.ListCrossAccountAttachmentsResponse(
        crossAccountAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def crossAccountAttachments
        : Optional[List[zio.aws.globalaccelerator.model.Attachment.ReadOnly]]
    def nextToken: Optional[GenericString]
    def getCrossAccountAttachments: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.Attachment.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "crossAccountAttachments",
      crossAccountAttachments
    )
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsResponse
  ) extends zio.aws.globalaccelerator.model.ListCrossAccountAttachmentsResponse.ReadOnly {
    override val crossAccountAttachments
        : Optional[List[zio.aws.globalaccelerator.model.Attachment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crossAccountAttachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.Attachment.wrap(item)
          }.toList
        )
    override val nextToken: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsResponse
  ): zio.aws.globalaccelerator.model.ListCrossAccountAttachmentsResponse.ReadOnly =
    new Wrapper(impl)
}
