package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DescribeCrossAccountAttachmentRequest(
    attachmentArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentRequest = {
    import DescribeCrossAccountAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentRequest
      .builder()
      .attachmentArn(attachmentArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeCrossAccountAttachmentRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeCrossAccountAttachmentRequest
      .wrap(buildAwsValue())
}
object DescribeCrossAccountAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeCrossAccountAttachmentRequest =
      zio.aws.globalaccelerator.model
        .DescribeCrossAccountAttachmentRequest(attachmentArn)
    def attachmentArn: GenericString
    def getAttachmentArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(attachmentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentRequest
  ) extends zio.aws.globalaccelerator.model.DescribeCrossAccountAttachmentRequest.ReadOnly {
    override val attachmentArn: GenericString =
      impl.attachmentArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCrossAccountAttachmentRequest
  ): zio.aws.globalaccelerator.model.DescribeCrossAccountAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
