package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DeleteCrossAccountAttachmentRequest(
    attachmentArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DeleteCrossAccountAttachmentRequest = {
    import DeleteCrossAccountAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DeleteCrossAccountAttachmentRequest
      .builder()
      .attachmentArn(attachmentArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DeleteCrossAccountAttachmentRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DeleteCrossAccountAttachmentRequest
      .wrap(buildAwsValue())
}
object DeleteCrossAccountAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DeleteCrossAccountAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DeleteCrossAccountAttachmentRequest =
      zio.aws.globalaccelerator.model
        .DeleteCrossAccountAttachmentRequest(attachmentArn)
    def attachmentArn: GenericString
    def getAttachmentArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(attachmentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteCrossAccountAttachmentRequest
  ) extends zio.aws.globalaccelerator.model.DeleteCrossAccountAttachmentRequest.ReadOnly {
    override val attachmentArn: GenericString =
      impl.attachmentArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteCrossAccountAttachmentRequest
  ): zio.aws.globalaccelerator.model.DeleteCrossAccountAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
