package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.PortNumber
import scala.jdk.CollectionConverters._
final case class CustomRoutingDestinationConfiguration(
    fromPort: PortNumber,
    toPort: PortNumber,
    protocols: Iterable[zio.aws.globalaccelerator.model.CustomRoutingProtocol]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationConfiguration = {
    import CustomRoutingDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationConfiguration
      .builder()
      .fromPort(PortNumber.unwrap(fromPort): Integer)
      .toPort(PortNumber.unwrap(toPort): Integer)
      .protocolsWithStrings(protocols.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CustomRoutingDestinationConfiguration.ReadOnly =
    zio.aws.globalaccelerator.model.CustomRoutingDestinationConfiguration
      .wrap(buildAwsValue())
}
object CustomRoutingDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.CustomRoutingDestinationConfiguration =
      zio.aws.globalaccelerator.model
        .CustomRoutingDestinationConfiguration(fromPort, toPort, protocols)
    def fromPort: PortNumber
    def toPort: PortNumber
    def protocols: List[zio.aws.globalaccelerator.model.CustomRoutingProtocol]
    def getFromPort: ZIO[Any, Nothing, PortNumber] = ZIO.succeed(fromPort)
    def getToPort: ZIO[Any, Nothing, PortNumber] = ZIO.succeed(toPort)
    def getProtocols: ZIO[Any, Nothing, List[
      zio.aws.globalaccelerator.model.CustomRoutingProtocol
    ]] = ZIO.succeed(protocols)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationConfiguration
  ) extends zio.aws.globalaccelerator.model.CustomRoutingDestinationConfiguration.ReadOnly {
    override val fromPort: PortNumber =
      zio.aws.globalaccelerator.model.primitives.PortNumber(impl.fromPort())
    override val toPort: PortNumber =
      zio.aws.globalaccelerator.model.primitives.PortNumber(impl.toPort())
    override val protocols
        : List[zio.aws.globalaccelerator.model.CustomRoutingProtocol] = impl
      .protocols()
      .asScala
      .map { item =>
        zio.aws.globalaccelerator.model.CustomRoutingProtocol.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationConfiguration
  ): zio.aws.globalaccelerator.model.CustomRoutingDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
