package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class CrossAccountResource(
    endpointId: Optional[GenericString] = Optional.Absent,
    attachmentArn: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CrossAccountResource = {
    import CrossAccountResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CrossAccountResource
      .builder()
      .optionallyWith(endpointId.map(value => value: java.lang.String))(
        _.endpointId
      )
      .optionallyWith(attachmentArn.map(value => value: java.lang.String))(
        _.attachmentArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CrossAccountResource.ReadOnly =
    zio.aws.globalaccelerator.model.CrossAccountResource.wrap(buildAwsValue())
}
object CrossAccountResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CrossAccountResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.CrossAccountResource =
      zio.aws.globalaccelerator.model.CrossAccountResource(
        endpointId.map(value => value),
        attachmentArn.map(value => value)
      )
    def endpointId: Optional[GenericString]
    def attachmentArn: Optional[GenericString]
    def getEndpointId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointId", endpointId)
    def getAttachmentArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("attachmentArn", attachmentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CrossAccountResource
  ) extends zio.aws.globalaccelerator.model.CrossAccountResource.ReadOnly {
    override val endpointId: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointId())
      .map(value => value: GenericString)
    override val attachmentArn: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentArn())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CrossAccountResource
  ): zio.aws.globalaccelerator.model.CrossAccountResource.ReadOnly =
    new Wrapper(impl)
}
