package zio.aws.globalaccelerator.model
import zio.aws.globalaccelerator.model.primitives.{
  Timestamp,
  Principal,
  AttachmentName,
  GenericString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Attachment(
    attachmentArn: Optional[GenericString] = Optional.Absent,
    name: Optional[AttachmentName] = Optional.Absent,
    principals: Optional[Iterable[Principal]] = Optional.Absent,
    resources: Optional[Iterable[zio.aws.globalaccelerator.model.Resource]] =
      Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.Attachment = {
    import Attachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.Attachment
      .builder()
      .optionallyWith(attachmentArn.map(value => value: java.lang.String))(
        _.attachmentArn
      )
      .optionallyWith(
        name.map(value => AttachmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        principals.map(value =>
          value.map { item =>
            Principal.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.principals)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.Attachment.ReadOnly =
    zio.aws.globalaccelerator.model.Attachment.wrap(buildAwsValue())
}
object Attachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.Attachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.Attachment =
      zio.aws.globalaccelerator.model.Attachment(
        attachmentArn.map(value => value),
        name.map(value => value),
        principals.map(value => value),
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastModifiedTime.map(value => value),
        createdTime.map(value => value)
      )
    def attachmentArn: Optional[GenericString]
    def name: Optional[AttachmentName]
    def principals: Optional[List[Principal]]
    def resources
        : Optional[List[zio.aws.globalaccelerator.model.Resource.ReadOnly]]
    def lastModifiedTime: Optional[Timestamp]
    def createdTime: Optional[Timestamp]
    def getAttachmentArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("attachmentArn", attachmentArn)
    def getName: ZIO[Any, AwsError, AttachmentName] =
      AwsError.unwrapOptionField("name", name)
    def getPrincipals: ZIO[Any, AwsError, List[Principal]] =
      AwsError.unwrapOptionField("principals", principals)
    def getResources: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.Resource.ReadOnly
    ]] = AwsError.unwrapOptionField("resources", resources)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.Attachment
  ) extends zio.aws.globalaccelerator.model.Attachment.ReadOnly {
    override val attachmentArn: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentArn())
      .map(value => value: GenericString)
    override val name: Optional[AttachmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.AttachmentName(value)
      )
    override val principals: Optional[List[Principal]] = zio.aws.core.internal
      .optionalFromNullable(impl.principals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.primitives.Principal(item)
        }.toList
      )
    override val resources
        : Optional[List[zio.aws.globalaccelerator.model.Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.Resource.wrap(item)
          }.toList
        )
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.globalaccelerator.model.primitives.Timestamp(value))
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.globalaccelerator.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.Attachment
  ): zio.aws.globalaccelerator.model.Attachment.ReadOnly = new Wrapper(impl)
}
