package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCrossAccountAttachmentResponse(
    crossAccountAttachment: Optional[
      zio.aws.globalaccelerator.model.Attachment
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentResponse = {
    import UpdateCrossAccountAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentResponse
      .builder()
      .optionallyWith(
        crossAccountAttachment.map(value => value.buildAwsValue())
      )(_.crossAccountAttachment)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateCrossAccountAttachmentResponse.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateCrossAccountAttachmentResponse
      .wrap(buildAwsValue())
}
object UpdateCrossAccountAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.UpdateCrossAccountAttachmentResponse =
      zio.aws.globalaccelerator.model.UpdateCrossAccountAttachmentResponse(
        crossAccountAttachment.map(value => value.asEditable)
      )
    def crossAccountAttachment
        : Optional[zio.aws.globalaccelerator.model.Attachment.ReadOnly]
    def getCrossAccountAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.Attachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "crossAccountAttachment",
      crossAccountAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentResponse
  ) extends zio.aws.globalaccelerator.model.UpdateCrossAccountAttachmentResponse.ReadOnly {
    override val crossAccountAttachment
        : Optional[zio.aws.globalaccelerator.model.Attachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crossAccountAttachment())
        .map(value => zio.aws.globalaccelerator.model.Attachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentResponse
  ): zio.aws.globalaccelerator.model.UpdateCrossAccountAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
