package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.{
  Principal,
  AttachmentName,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class UpdateCrossAccountAttachmentRequest(
    attachmentArn: GenericString,
    name: Optional[AttachmentName] = Optional.Absent,
    addPrincipals: Optional[Iterable[Principal]] = Optional.Absent,
    removePrincipals: Optional[Iterable[Principal]] = Optional.Absent,
    addResources: Optional[Iterable[zio.aws.globalaccelerator.model.Resource]] =
      Optional.Absent,
    removeResources: Optional[
      Iterable[zio.aws.globalaccelerator.model.Resource]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentRequest = {
    import UpdateCrossAccountAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentRequest
      .builder()
      .attachmentArn(attachmentArn: java.lang.String)
      .optionallyWith(
        name.map(value => AttachmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        addPrincipals.map(value =>
          value.map { item =>
            Principal.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addPrincipals)
      .optionallyWith(
        removePrincipals.map(value =>
          value.map { item =>
            Principal.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removePrincipals)
      .optionallyWith(
        addResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addResources)
      .optionallyWith(
        removeResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.removeResources)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateCrossAccountAttachmentRequest.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateCrossAccountAttachmentRequest
      .wrap(buildAwsValue())
}
object UpdateCrossAccountAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.UpdateCrossAccountAttachmentRequest =
      zio.aws.globalaccelerator.model.UpdateCrossAccountAttachmentRequest(
        attachmentArn,
        name.map(value => value),
        addPrincipals.map(value => value),
        removePrincipals.map(value => value),
        addResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attachmentArn: GenericString
    def name: Optional[AttachmentName]
    def addPrincipals: Optional[List[Principal]]
    def removePrincipals: Optional[List[Principal]]
    def addResources
        : Optional[List[zio.aws.globalaccelerator.model.Resource.ReadOnly]]
    def removeResources
        : Optional[List[zio.aws.globalaccelerator.model.Resource.ReadOnly]]
    def getAttachmentArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(attachmentArn)
    def getName: ZIO[Any, AwsError, AttachmentName] =
      AwsError.unwrapOptionField("name", name)
    def getAddPrincipals: ZIO[Any, AwsError, List[Principal]] =
      AwsError.unwrapOptionField("addPrincipals", addPrincipals)
    def getRemovePrincipals: ZIO[Any, AwsError, List[Principal]] =
      AwsError.unwrapOptionField("removePrincipals", removePrincipals)
    def getAddResources: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.Resource.ReadOnly
    ]] = AwsError.unwrapOptionField("addResources", addResources)
    def getRemoveResources: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.Resource.ReadOnly
    ]] = AwsError.unwrapOptionField("removeResources", removeResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentRequest
  ) extends zio.aws.globalaccelerator.model.UpdateCrossAccountAttachmentRequest.ReadOnly {
    override val attachmentArn: GenericString =
      impl.attachmentArn(): GenericString
    override val name: Optional[AttachmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.AttachmentName(value)
      )
    override val addPrincipals: Optional[List[Principal]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addPrincipals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.primitives.Principal(item)
          }.toList
        )
    override val removePrincipals: Optional[List[Principal]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removePrincipals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.primitives.Principal(item)
          }.toList
        )
    override val addResources
        : Optional[List[zio.aws.globalaccelerator.model.Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.Resource.wrap(item)
          }.toList
        )
    override val removeResources
        : Optional[List[zio.aws.globalaccelerator.model.Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.Resource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCrossAccountAttachmentRequest
  ): zio.aws.globalaccelerator.model.UpdateCrossAccountAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
