package zio.aws.globalaccelerator.model
import zio.aws.globalaccelerator.model.primitives.{
  MaxResults,
  AwsAccountId,
  GenericString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCrossAccountResourcesRequest(
    acceleratorArn: Optional[GenericString] = Optional.Absent,
    resourceOwnerAwsAccountId: AwsAccountId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesRequest = {
    import ListCrossAccountResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesRequest
      .builder()
      .optionallyWith(acceleratorArn.map(value => value: java.lang.String))(
        _.acceleratorArn
      )
      .resourceOwnerAwsAccountId(
        AwsAccountId.unwrap(resourceOwnerAwsAccountId): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCrossAccountResourcesRequest.ReadOnly =
    zio.aws.globalaccelerator.model.ListCrossAccountResourcesRequest
      .wrap(buildAwsValue())
}
object ListCrossAccountResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCrossAccountResourcesRequest =
      zio.aws.globalaccelerator.model.ListCrossAccountResourcesRequest(
        acceleratorArn.map(value => value),
        resourceOwnerAwsAccountId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def acceleratorArn: Optional[GenericString]
    def resourceOwnerAwsAccountId: AwsAccountId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[GenericString]
    def getAcceleratorArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("acceleratorArn", acceleratorArn)
    def getResourceOwnerAwsAccountId: ZIO[Any, Nothing, AwsAccountId] =
      ZIO.succeed(resourceOwnerAwsAccountId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesRequest
  ) extends zio.aws.globalaccelerator.model.ListCrossAccountResourcesRequest.ReadOnly {
    override val acceleratorArn: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorArn())
      .map(value => value: GenericString)
    override val resourceOwnerAwsAccountId: AwsAccountId =
      zio.aws.globalaccelerator.model.primitives
        .AwsAccountId(impl.resourceOwnerAwsAccountId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesRequest
  ): zio.aws.globalaccelerator.model.ListCrossAccountResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
