package zio.aws.globalaccelerator.model
import zio.aws.globalaccelerator.model.primitives.{GenericString, MaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCrossAccountAttachmentsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsRequest = {
    import ListCrossAccountAttachmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCrossAccountAttachmentsRequest.ReadOnly =
    zio.aws.globalaccelerator.model.ListCrossAccountAttachmentsRequest
      .wrap(buildAwsValue())
}
object ListCrossAccountAttachmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCrossAccountAttachmentsRequest =
      zio.aws.globalaccelerator.model.ListCrossAccountAttachmentsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[GenericString]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsRequest
  ) extends zio.aws.globalaccelerator.model.ListCrossAccountAttachmentsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsRequest
  ): zio.aws.globalaccelerator.model.ListCrossAccountAttachmentsRequest.ReadOnly =
    new Wrapper(impl)
}
