package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.{
  IdempotencyToken,
  Principal,
  AttachmentName
}
import scala.jdk.CollectionConverters._
final case class CreateCrossAccountAttachmentRequest(
    name: AttachmentName,
    principals: Optional[Iterable[Principal]] = Optional.Absent,
    resources: Optional[Iterable[zio.aws.globalaccelerator.model.Resource]] =
      Optional.Absent,
    idempotencyToken: IdempotencyToken,
    tags: Optional[Iterable[zio.aws.globalaccelerator.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentRequest = {
    import CreateCrossAccountAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentRequest
      .builder()
      .name(AttachmentName.unwrap(name): java.lang.String)
      .optionallyWith(
        principals.map(value =>
          value.map { item =>
            Principal.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.principals)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CreateCrossAccountAttachmentRequest.ReadOnly =
    zio.aws.globalaccelerator.model.CreateCrossAccountAttachmentRequest
      .wrap(buildAwsValue())
}
object CreateCrossAccountAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.CreateCrossAccountAttachmentRequest =
      zio.aws.globalaccelerator.model.CreateCrossAccountAttachmentRequest(
        name,
        principals.map(value => value),
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        idempotencyToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: AttachmentName
    def principals: Optional[List[Principal]]
    def resources
        : Optional[List[zio.aws.globalaccelerator.model.Resource.ReadOnly]]
    def idempotencyToken: IdempotencyToken
    def tags: Optional[List[zio.aws.globalaccelerator.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, AttachmentName] = ZIO.succeed(name)
    def getPrincipals: ZIO[Any, AwsError, List[Principal]] =
      AwsError.unwrapOptionField("principals", principals)
    def getResources: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.Resource.ReadOnly
    ]] = AwsError.unwrapOptionField("resources", resources)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentRequest
  ) extends zio.aws.globalaccelerator.model.CreateCrossAccountAttachmentRequest.ReadOnly {
    override val name: AttachmentName =
      zio.aws.globalaccelerator.model.primitives.AttachmentName(impl.name())
    override val principals: Optional[List[Principal]] = zio.aws.core.internal
      .optionalFromNullable(impl.principals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.primitives.Principal(item)
        }.toList
      )
    override val resources
        : Optional[List[zio.aws.globalaccelerator.model.Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.Resource.wrap(item)
          }.toList
        )
    override val idempotencyToken: IdempotencyToken =
      zio.aws.globalaccelerator.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
    override val tags
        : Optional[List[zio.aws.globalaccelerator.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateCrossAccountAttachmentRequest
  ): zio.aws.globalaccelerator.model.CreateCrossAccountAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
