package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateListenerResponse(
    listener: Optional[zio.aws.globalaccelerator.model.Listener] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse = {
    import UpdateListenerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse
      .builder()
      .optionallyWith(listener.map(value => value.buildAwsValue()))(_.listener)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateListenerResponse.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateListenerResponse.wrap(buildAwsValue())
}
object UpdateListenerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.UpdateListenerResponse =
      zio.aws.globalaccelerator.model
        .UpdateListenerResponse(listener.map(value => value.asEditable))
    def listener: Optional[zio.aws.globalaccelerator.model.Listener.ReadOnly]
    def getListener: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.Listener.ReadOnly
    ] = AwsError.unwrapOptionField("listener", listener)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse
  ) extends zio.aws.globalaccelerator.model.UpdateListenerResponse.ReadOnly {
    override val listener
        : Optional[zio.aws.globalaccelerator.model.Listener.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listener())
        .map(value => zio.aws.globalaccelerator.model.Listener.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse
  ): zio.aws.globalaccelerator.model.UpdateListenerResponse.ReadOnly =
    new Wrapper(impl)
}
