package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class CustomRoutingEndpointGroup(
    endpointGroupArn: Optional[GenericString] = Optional.Absent,
    endpointGroupRegion: Optional[GenericString] = Optional.Absent,
    destinationDescriptions: Optional[Iterable[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription
    ]] = Optional.Absent,
    endpointDescriptions: Optional[
      Iterable[zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup = {
    import CustomRoutingEndpointGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup
      .builder()
      .optionallyWith(endpointGroupArn.map(value => value: java.lang.String))(
        _.endpointGroupArn
      )
      .optionallyWith(
        endpointGroupRegion.map(value => value: java.lang.String)
      )(_.endpointGroupRegion)
      .optionallyWith(
        destinationDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationDescriptions)
      .optionallyWith(
        endpointDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly =
    zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup
      .wrap(buildAwsValue())
}
object CustomRoutingEndpointGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup =
      zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup(
        endpointGroupArn.map(value => value),
        endpointGroupRegion.map(value => value),
        destinationDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        endpointDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def endpointGroupArn: Optional[GenericString]
    def endpointGroupRegion: Optional[GenericString]
    def destinationDescriptions: Optional[List[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription.ReadOnly
    ]]
    def endpointDescriptions: Optional[List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription.ReadOnly
    ]]
    def getEndpointGroupArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupArn", endpointGroupArn)
    def getEndpointGroupRegion: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupRegion", endpointGroupRegion)
    def getDestinationDescriptions: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "destinationDescriptions",
      destinationDescriptions
    )
    def getEndpointDescriptions: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("endpointDescriptions", endpointDescriptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup
  ) extends zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly {
    override val endpointGroupArn: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointGroupArn())
        .map(value => value: GenericString)
    override val endpointGroupRegion: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointGroupRegion())
        .map(value => value: GenericString)
    override val destinationDescriptions: Optional[List[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.CustomRoutingDestinationDescription
            .wrap(item)
        }.toList
      )
    override val endpointDescriptions: Optional[List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup
  ): zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly =
    new Wrapper(impl)
}
