package zio.aws.globalaccelerator.model
import zio.aws.globalaccelerator.model.primitives.{
  GenericBoolean,
  PortNumber,
  IpAddress,
  GenericString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AllowCustomRoutingTrafficRequest(
    endpointGroupArn: GenericString,
    endpointId: GenericString,
    destinationAddresses: Optional[Iterable[IpAddress]] = Optional.Absent,
    destinationPorts: Optional[Iterable[PortNumber]] = Optional.Absent,
    allowAllTrafficToEndpoint: Optional[GenericBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest = {
    import AllowCustomRoutingTrafficRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest
      .builder()
      .endpointGroupArn(endpointGroupArn: java.lang.String)
      .endpointId(endpointId: java.lang.String)
      .optionallyWith(
        destinationAddresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.destinationAddresses)
      .optionallyWith(
        destinationPorts.map(value =>
          value.map { item =>
            PortNumber.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.destinationPorts)
      .optionallyWith(
        allowAllTrafficToEndpoint.map(value => value: java.lang.Boolean)
      )(_.allowAllTrafficToEndpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.AllowCustomRoutingTrafficRequest.ReadOnly =
    zio.aws.globalaccelerator.model.AllowCustomRoutingTrafficRequest
      .wrap(buildAwsValue())
}
object AllowCustomRoutingTrafficRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.AllowCustomRoutingTrafficRequest =
      zio.aws.globalaccelerator.model.AllowCustomRoutingTrafficRequest(
        endpointGroupArn,
        endpointId,
        destinationAddresses.map(value => value),
        destinationPorts.map(value => value),
        allowAllTrafficToEndpoint.map(value => value)
      )
    def endpointGroupArn: GenericString
    def endpointId: GenericString
    def destinationAddresses: Optional[List[IpAddress]]
    def destinationPorts: Optional[List[PortNumber]]
    def allowAllTrafficToEndpoint: Optional[GenericBoolean]
    def getEndpointGroupArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointGroupArn)
    def getEndpointId: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointId)
    def getDestinationAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("destinationAddresses", destinationAddresses)
    def getDestinationPorts: ZIO[Any, AwsError, List[PortNumber]] =
      AwsError.unwrapOptionField("destinationPorts", destinationPorts)
    def getAllowAllTrafficToEndpoint: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField(
        "allowAllTrafficToEndpoint",
        allowAllTrafficToEndpoint
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest
  ) extends zio.aws.globalaccelerator.model.AllowCustomRoutingTrafficRequest.ReadOnly {
    override val endpointGroupArn: GenericString =
      impl.endpointGroupArn(): GenericString
    override val endpointId: GenericString = impl.endpointId(): GenericString
    override val destinationAddresses: Optional[List[IpAddress]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.primitives.IpAddress(item)
          }.toList
        )
    override val destinationPorts: Optional[List[PortNumber]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPorts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.primitives.PortNumber(item)
          }.toList
        )
    override val allowAllTrafficToEndpoint: Optional[GenericBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowAllTrafficToEndpoint())
        .map(value => value: GenericBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest
  ): zio.aws.globalaccelerator.model.AllowCustomRoutingTrafficRequest.ReadOnly =
    new Wrapper(impl)
}
