package zio.aws.globalaccelerator.model
import zio.aws.globalaccelerator.model.primitives.{
  GenericBoolean,
  PortNumber,
  IpAddress,
  GenericString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DenyCustomRoutingTrafficRequest(
    endpointGroupArn: GenericString,
    endpointId: GenericString,
    destinationAddresses: Optional[Iterable[IpAddress]] = Optional.Absent,
    destinationPorts: Optional[Iterable[PortNumber]] = Optional.Absent,
    denyAllTrafficToEndpoint: Optional[GenericBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest = {
    import DenyCustomRoutingTrafficRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest
      .builder()
      .endpointGroupArn(endpointGroupArn: java.lang.String)
      .endpointId(endpointId: java.lang.String)
      .optionallyWith(
        destinationAddresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.destinationAddresses)
      .optionallyWith(
        destinationPorts.map(value =>
          value.map { item =>
            PortNumber.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.destinationPorts)
      .optionallyWith(
        denyAllTrafficToEndpoint.map(value => value: java.lang.Boolean)
      )(_.denyAllTrafficToEndpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DenyCustomRoutingTrafficRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DenyCustomRoutingTrafficRequest
      .wrap(buildAwsValue())
}
object DenyCustomRoutingTrafficRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DenyCustomRoutingTrafficRequest =
      zio.aws.globalaccelerator.model.DenyCustomRoutingTrafficRequest(
        endpointGroupArn,
        endpointId,
        destinationAddresses.map(value => value),
        destinationPorts.map(value => value),
        denyAllTrafficToEndpoint.map(value => value)
      )
    def endpointGroupArn: GenericString
    def endpointId: GenericString
    def destinationAddresses: Optional[List[IpAddress]]
    def destinationPorts: Optional[List[PortNumber]]
    def denyAllTrafficToEndpoint: Optional[GenericBoolean]
    def getEndpointGroupArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointGroupArn)
    def getEndpointId: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointId)
    def getDestinationAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("destinationAddresses", destinationAddresses)
    def getDestinationPorts: ZIO[Any, AwsError, List[PortNumber]] =
      AwsError.unwrapOptionField("destinationPorts", destinationPorts)
    def getDenyAllTrafficToEndpoint: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField(
        "denyAllTrafficToEndpoint",
        denyAllTrafficToEndpoint
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest
  ) extends zio.aws.globalaccelerator.model.DenyCustomRoutingTrafficRequest.ReadOnly {
    override val endpointGroupArn: GenericString =
      impl.endpointGroupArn(): GenericString
    override val endpointId: GenericString = impl.endpointId(): GenericString
    override val destinationAddresses: Optional[List[IpAddress]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.primitives.IpAddress(item)
          }.toList
        )
    override val destinationPorts: Optional[List[PortNumber]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPorts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.primitives.PortNumber(item)
          }.toList
        )
    override val denyAllTrafficToEndpoint: Optional[GenericBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.denyAllTrafficToEndpoint())
        .map(value => value: GenericBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest
  ): zio.aws.globalaccelerator.model.DenyCustomRoutingTrafficRequest.ReadOnly =
    new Wrapper(impl)
}
