package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WithdrawByoipCidrResponse(
    byoipCidr: Optional[zio.aws.globalaccelerator.model.ByoipCidr] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrResponse = {
    import WithdrawByoipCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrResponse
      .builder()
      .optionallyWith(byoipCidr.map(value => value.buildAwsValue()))(
        _.byoipCidr
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.WithdrawByoipCidrResponse.ReadOnly =
    zio.aws.globalaccelerator.model.WithdrawByoipCidrResponse
      .wrap(buildAwsValue())
}
object WithdrawByoipCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.WithdrawByoipCidrResponse =
      zio.aws.globalaccelerator.model
        .WithdrawByoipCidrResponse(byoipCidr.map(value => value.asEditable))
    def byoipCidr: Optional[zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly]
    def getByoipCidr: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly
    ] = AwsError.unwrapOptionField("byoipCidr", byoipCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrResponse
  ) extends zio.aws.globalaccelerator.model.WithdrawByoipCidrResponse.ReadOnly {
    override val byoipCidr
        : Optional[zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.byoipCidr())
        .map(value => zio.aws.globalaccelerator.model.ByoipCidr.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrResponse
  ): zio.aws.globalaccelerator.model.WithdrawByoipCidrResponse.ReadOnly =
    new Wrapper(impl)
}
