package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DescribeAcceleratorRequest(acceleratorArn: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest = {
    import DescribeAcceleratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest
      .builder()
      .acceleratorArn(acceleratorArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeAcceleratorRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeAcceleratorRequest
      .wrap(buildAwsValue())
}
object DescribeAcceleratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.DescribeAcceleratorRequest =
      zio.aws.globalaccelerator.model.DescribeAcceleratorRequest(acceleratorArn)
    def acceleratorArn: GenericString
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest
  ) extends zio.aws.globalaccelerator.model.DescribeAcceleratorRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      impl.acceleratorArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest
  ): zio.aws.globalaccelerator.model.DescribeAcceleratorRequest.ReadOnly =
    new Wrapper(impl)
}
