package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class RemoveEndpointsRequest(
    endpointIdentifiers: Iterable[
      zio.aws.globalaccelerator.model.EndpointIdentifier
    ],
    endpointGroupArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.RemoveEndpointsRequest = {
    import RemoveEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.RemoveEndpointsRequest
      .builder()
      .endpointIdentifiers(endpointIdentifiers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .endpointGroupArn(endpointGroupArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.RemoveEndpointsRequest.ReadOnly =
    zio.aws.globalaccelerator.model.RemoveEndpointsRequest.wrap(buildAwsValue())
}
object RemoveEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.RemoveEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.RemoveEndpointsRequest =
      zio.aws.globalaccelerator.model.RemoveEndpointsRequest(
        endpointIdentifiers.map { item =>
          item.asEditable
        },
        endpointGroupArn
      )
    def endpointIdentifiers
        : List[zio.aws.globalaccelerator.model.EndpointIdentifier.ReadOnly]
    def endpointGroupArn: GenericString
    def getEndpointIdentifiers: ZIO[Any, Nothing, List[
      zio.aws.globalaccelerator.model.EndpointIdentifier.ReadOnly
    ]] = ZIO.succeed(endpointIdentifiers)
    def getEndpointGroupArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.RemoveEndpointsRequest
  ) extends zio.aws.globalaccelerator.model.RemoveEndpointsRequest.ReadOnly {
    override val endpointIdentifiers
        : List[zio.aws.globalaccelerator.model.EndpointIdentifier.ReadOnly] =
      impl
        .endpointIdentifiers()
        .asScala
        .map { item =>
          zio.aws.globalaccelerator.model.EndpointIdentifier.wrap(item)
        }
        .toList
    override val endpointGroupArn: GenericString =
      impl.endpointGroupArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.RemoveEndpointsRequest
  ): zio.aws.globalaccelerator.model.RemoveEndpointsRequest.ReadOnly =
    new Wrapper(impl)
}
