package zio.aws.globalaccelerator.model
import scala.jdk.CollectionConverters._
sealed trait IpAddressType {
  def unwrap
      : software.amazon.awssdk.services.globalaccelerator.model.IpAddressType
}
object IpAddressType {
  def wrap(
      value: software.amazon.awssdk.services.globalaccelerator.model.IpAddressType
  ): zio.aws.globalaccelerator.model.IpAddressType = value match {
    case software.amazon.awssdk.services.globalaccelerator.model.IpAddressType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.globalaccelerator.model.IpAddressType.IPV4 =>
      val r = IPV4
      r
    case software.amazon.awssdk.services.globalaccelerator.model.IpAddressType.DUAL_STACK =>
      val r = DUAL_STACK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.globalaccelerator.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.IpAddressType =
      software.amazon.awssdk.services.globalaccelerator.model.IpAddressType.UNKNOWN_TO_SDK_VERSION
  }
  case object IPV4 extends zio.aws.globalaccelerator.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.IpAddressType =
      software.amazon.awssdk.services.globalaccelerator.model.IpAddressType.IPV4
  }
  case object DUAL_STACK extends zio.aws.globalaccelerator.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.IpAddressType =
      software.amazon.awssdk.services.globalaccelerator.model.IpAddressType.DUAL_STACK
  }
}
