package zio.aws.globalaccelerator.model
import scala.jdk.CollectionConverters._
sealed trait ClientAffinity {
  def unwrap
      : software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity
}
object ClientAffinity {
  def wrap(
      value: software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity
  ): zio.aws.globalaccelerator.model.ClientAffinity = value match {
    case software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity.SOURCE_IP =>
      val r = SOURCE_IP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.globalaccelerator.model.ClientAffinity {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity =
      software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.globalaccelerator.model.ClientAffinity {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity =
      software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity.NONE
  }
  case object SOURCE_IP extends zio.aws.globalaccelerator.model.ClientAffinity {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity =
      software.amazon.awssdk.services.globalaccelerator.model.ClientAffinity.SOURCE_IP
  }
}
