package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DescribeCustomRoutingListenerRequest(
    listenerArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest = {
    import DescribeCustomRoutingListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest
      .builder()
      .listenerArn(listenerArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerRequest
      .wrap(buildAwsValue())
}
object DescribeCustomRoutingListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerRequest =
      zio.aws.globalaccelerator.model
        .DescribeCustomRoutingListenerRequest(listenerArn)
    def listenerArn: GenericString
    def getListenerArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(listenerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest
  ) extends zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerRequest.ReadOnly {
    override val listenerArn: GenericString = impl.listenerArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest
  ): zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerRequest.ReadOnly =
    new Wrapper(impl)
}
