package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.{
  GenericBoolean,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class UpdateCustomRoutingAcceleratorAttributesRequest(
    acceleratorArn: GenericString,
    flowLogsEnabled: Optional[GenericBoolean] = Optional.Absent,
    flowLogsS3Bucket: Optional[GenericString] = Optional.Absent,
    flowLogsS3Prefix: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest = {
    import UpdateCustomRoutingAcceleratorAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest
      .builder()
      .acceleratorArn(acceleratorArn: java.lang.String)
      .optionallyWith(flowLogsEnabled.map(value => value: java.lang.Boolean))(
        _.flowLogsEnabled
      )
      .optionallyWith(flowLogsS3Bucket.map(value => value: java.lang.String))(
        _.flowLogsS3Bucket
      )
      .optionallyWith(flowLogsS3Prefix.map(value => value: java.lang.String))(
        _.flowLogsS3Prefix
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest
      .wrap(buildAwsValue())
}
object UpdateCustomRoutingAcceleratorAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest =
      zio.aws.globalaccelerator.model
        .UpdateCustomRoutingAcceleratorAttributesRequest(
          acceleratorArn,
          flowLogsEnabled.map(value => value),
          flowLogsS3Bucket.map(value => value),
          flowLogsS3Prefix.map(value => value)
        )
    def acceleratorArn: GenericString
    def flowLogsEnabled: Optional[GenericBoolean]
    def flowLogsS3Bucket: Optional[GenericString]
    def flowLogsS3Prefix: Optional[GenericString]
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
    def getFlowLogsEnabled: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField("flowLogsEnabled", flowLogsEnabled)
    def getFlowLogsS3Bucket: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("flowLogsS3Bucket", flowLogsS3Bucket)
    def getFlowLogsS3Prefix: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("flowLogsS3Prefix", flowLogsS3Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest
  ) extends zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      impl.acceleratorArn(): GenericString
    override val flowLogsEnabled: Optional[GenericBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowLogsEnabled())
        .map(value => value: GenericBoolean)
    override val flowLogsS3Bucket: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowLogsS3Bucket())
        .map(value => value: GenericString)
    override val flowLogsS3Prefix: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowLogsS3Prefix())
        .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest
  ): zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
