package zio.aws.globalaccelerator.model
import scala.jdk.CollectionConverters._
sealed trait HealthCheckProtocol {
  def unwrap: software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol
}
object HealthCheckProtocol {
  def wrap(
      value: software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol
  ): zio.aws.globalaccelerator.model.HealthCheckProtocol = value match {
    case software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol.TCP =>
      val r = TCP
      r
    case software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol.HTTP =>
      val r = HTTP
      r
    case software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol.HTTPS =>
      val r = HTTPS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.globalaccelerator.model.HealthCheckProtocol {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol =
      software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object TCP extends zio.aws.globalaccelerator.model.HealthCheckProtocol {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol =
      software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol.TCP
  }
  case object HTTP extends zio.aws.globalaccelerator.model.HealthCheckProtocol {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol =
      software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol.HTTP
  }
  case object HTTPS
      extends zio.aws.globalaccelerator.model.HealthCheckProtocol {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol =
      software.amazon.awssdk.services.globalaccelerator.model.HealthCheckProtocol.HTTPS
  }
}
