package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class CustomRoutingListener(
    listenerArn: Optional[GenericString] = Optional.Absent,
    portRanges: Optional[Iterable[zio.aws.globalaccelerator.model.PortRange]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener = {
    import CustomRoutingListener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener
      .builder()
      .optionallyWith(listenerArn.map(value => value: java.lang.String))(
        _.listenerArn
      )
      .optionallyWith(
        portRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portRanges)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly =
    zio.aws.globalaccelerator.model.CustomRoutingListener.wrap(buildAwsValue())
}
object CustomRoutingListener {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.CustomRoutingListener =
      zio.aws.globalaccelerator.model.CustomRoutingListener(
        listenerArn.map(value => value),
        portRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def listenerArn: Optional[GenericString]
    def portRanges
        : Optional[List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]]
    def getListenerArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("listenerArn", listenerArn)
    def getPortRanges: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.PortRange.ReadOnly
    ]] = AwsError.unwrapOptionField("portRanges", portRanges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener
  ) extends zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly {
    override val listenerArn: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.listenerArn())
      .map(value => value: GenericString)
    override val portRanges
        : Optional[List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.PortRange.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener
  ): zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly =
    new Wrapper(impl)
}
