package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class AddEndpointsRequest(
    endpointConfigurations: Iterable[
      zio.aws.globalaccelerator.model.EndpointConfiguration
    ],
    endpointGroupArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsRequest = {
    import AddEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsRequest
      .builder()
      .endpointConfigurations(endpointConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .endpointGroupArn(endpointGroupArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.AddEndpointsRequest.ReadOnly =
    zio.aws.globalaccelerator.model.AddEndpointsRequest.wrap(buildAwsValue())
}
object AddEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.AddEndpointsRequest =
      zio.aws.globalaccelerator.model.AddEndpointsRequest(
        endpointConfigurations.map { item =>
          item.asEditable
        },
        endpointGroupArn
      )
    def endpointConfigurations
        : List[zio.aws.globalaccelerator.model.EndpointConfiguration.ReadOnly]
    def endpointGroupArn: GenericString
    def getEndpointConfigurations: ZIO[Any, Nothing, List[
      zio.aws.globalaccelerator.model.EndpointConfiguration.ReadOnly
    ]] = ZIO.succeed(endpointConfigurations)
    def getEndpointGroupArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsRequest
  ) extends zio.aws.globalaccelerator.model.AddEndpointsRequest.ReadOnly {
    override val endpointConfigurations
        : List[zio.aws.globalaccelerator.model.EndpointConfiguration.ReadOnly] =
      impl
        .endpointConfigurations()
        .asScala
        .map { item =>
          zio.aws.globalaccelerator.model.EndpointConfiguration.wrap(item)
        }
        .toList
    override val endpointGroupArn: GenericString =
      impl.endpointGroupArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsRequest
  ): zio.aws.globalaccelerator.model.AddEndpointsRequest.ReadOnly = new Wrapper(
    impl
  )
}
