package zio.aws.globalaccelerator.model
import scala.jdk.CollectionConverters._
sealed trait IpAddressFamily {
  def unwrap
      : software.amazon.awssdk.services.globalaccelerator.model.IpAddressFamily
}
object IpAddressFamily {
  def wrap(
      value: software.amazon.awssdk.services.globalaccelerator.model.IpAddressFamily
  ): zio.aws.globalaccelerator.model.IpAddressFamily = value match {
    case software.amazon.awssdk.services.globalaccelerator.model.IpAddressFamily.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.globalaccelerator.model.IpAddressFamily.IP_V4 =>
      val r = IPv4
      r
    case software.amazon.awssdk.services.globalaccelerator.model.IpAddressFamily.IP_V6 =>
      val r = IPv6
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.globalaccelerator.model.IpAddressFamily {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.IpAddressFamily =
      software.amazon.awssdk.services.globalaccelerator.model.IpAddressFamily.UNKNOWN_TO_SDK_VERSION
  }
  case object IPv4 extends zio.aws.globalaccelerator.model.IpAddressFamily {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.IpAddressFamily =
      software.amazon.awssdk.services.globalaccelerator.model.IpAddressFamily.IP_V4
  }
  case object IPv6 extends zio.aws.globalaccelerator.model.IpAddressFamily {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.IpAddressFamily =
      software.amazon.awssdk.services.globalaccelerator.model.IpAddressFamily.IP_V6
  }
}
