package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.{
  GenericBoolean,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class EndpointIdentifier(
    endpointId: GenericString,
    clientIPPreservationEnabled: Optional[GenericBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.EndpointIdentifier = {
    import EndpointIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.EndpointIdentifier
      .builder()
      .endpointId(endpointId: java.lang.String)
      .optionallyWith(
        clientIPPreservationEnabled.map(value => value: java.lang.Boolean)
      )(_.clientIPPreservationEnabled)
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.EndpointIdentifier.ReadOnly =
    zio.aws.globalaccelerator.model.EndpointIdentifier.wrap(buildAwsValue())
}
object EndpointIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.EndpointIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.EndpointIdentifier =
      zio.aws.globalaccelerator.model.EndpointIdentifier(
        endpointId,
        clientIPPreservationEnabled.map(value => value)
      )
    def endpointId: GenericString
    def clientIPPreservationEnabled: Optional[GenericBoolean]
    def getEndpointId: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointId)
    def getClientIPPreservationEnabled: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField(
        "clientIPPreservationEnabled",
        clientIPPreservationEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.EndpointIdentifier
  ) extends zio.aws.globalaccelerator.model.EndpointIdentifier.ReadOnly {
    override val endpointId: GenericString = impl.endpointId(): GenericString
    override val clientIPPreservationEnabled: Optional[GenericBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientIPPreservationEnabled())
        .map(value => value: GenericBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.EndpointIdentifier
  ): zio.aws.globalaccelerator.model.EndpointIdentifier.ReadOnly = new Wrapper(
    impl
  )
}
