package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCustomRoutingListenerResponse(
    listener: Optional[zio.aws.globalaccelerator.model.CustomRoutingListener] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerResponse = {
    import DescribeCustomRoutingListenerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerResponse
      .builder()
      .optionallyWith(listener.map(value => value.buildAwsValue()))(_.listener)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerResponse.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerResponse
      .wrap(buildAwsValue())
}
object DescribeCustomRoutingListenerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerResponse =
      zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerResponse(
        listener.map(value => value.asEditable)
      )
    def listener: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly
    ]
    def getListener: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly
    ] = AwsError.unwrapOptionField("listener", listener)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerResponse
  ) extends zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerResponse.ReadOnly {
    override val listener: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listener())
      .map(value =>
        zio.aws.globalaccelerator.model.CustomRoutingListener.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerResponse
  ): zio.aws.globalaccelerator.model.DescribeCustomRoutingListenerResponse.ReadOnly =
    new Wrapper(impl)
}
