package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class CustomRoutingEndpointConfiguration(
    endpointId: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointConfiguration = {
    import CustomRoutingEndpointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointConfiguration
      .builder()
      .optionallyWith(endpointId.map(value => value: java.lang.String))(
        _.endpointId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CustomRoutingEndpointConfiguration.ReadOnly =
    zio.aws.globalaccelerator.model.CustomRoutingEndpointConfiguration
      .wrap(buildAwsValue())
}
object CustomRoutingEndpointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.CustomRoutingEndpointConfiguration =
      zio.aws.globalaccelerator.model
        .CustomRoutingEndpointConfiguration(endpointId.map(value => value))
    def endpointId: Optional[GenericString]
    def getEndpointId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointId", endpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointConfiguration
  ) extends zio.aws.globalaccelerator.model.CustomRoutingEndpointConfiguration.ReadOnly {
    override val endpointId: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointId())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointConfiguration
  ): zio.aws.globalaccelerator.model.CustomRoutingEndpointConfiguration.ReadOnly =
    new Wrapper(impl)
}
