package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.{
  GenericBoolean,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class UpdateCustomRoutingAcceleratorRequest(
    acceleratorArn: GenericString,
    name: Optional[GenericString] = Optional.Absent,
    ipAddressType: Optional[zio.aws.globalaccelerator.model.IpAddressType] =
      Optional.Absent,
    enabled: Optional[GenericBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest = {
    import UpdateCustomRoutingAcceleratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest
      .builder()
      .acceleratorArn(acceleratorArn: java.lang.String)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest
      .wrap(buildAwsValue())
}
object UpdateCustomRoutingAcceleratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest =
      zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest(
        acceleratorArn,
        name.map(value => value),
        ipAddressType.map(value => value),
        enabled.map(value => value)
      )
    def acceleratorArn: GenericString
    def name: Optional[GenericString]
    def ipAddressType: Optional[zio.aws.globalaccelerator.model.IpAddressType]
    def enabled: Optional[GenericBoolean]
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
    def getName: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("name", name)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getEnabled: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest
  ) extends zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      impl.acceleratorArn(): GenericString
    override val name: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: GenericString)
    override val ipAddressType
        : Optional[zio.aws.globalaccelerator.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.globalaccelerator.model.IpAddressType.wrap(value))
    override val enabled: Optional[GenericBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: GenericBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest
  ): zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest.ReadOnly =
    new Wrapper(impl)
}
