package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class AddEndpointsResponse(
    endpointDescriptions: Optional[
      Iterable[zio.aws.globalaccelerator.model.EndpointDescription]
    ] = Optional.Absent,
    endpointGroupArn: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsResponse = {
    import AddEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsResponse
      .builder()
      .optionallyWith(
        endpointDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointDescriptions)
      .optionallyWith(endpointGroupArn.map(value => value: java.lang.String))(
        _.endpointGroupArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.AddEndpointsResponse.ReadOnly =
    zio.aws.globalaccelerator.model.AddEndpointsResponse.wrap(buildAwsValue())
}
object AddEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.AddEndpointsResponse =
      zio.aws.globalaccelerator.model.AddEndpointsResponse(
        endpointDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        endpointGroupArn.map(value => value)
      )
    def endpointDescriptions: Optional[
      List[zio.aws.globalaccelerator.model.EndpointDescription.ReadOnly]
    ]
    def endpointGroupArn: Optional[GenericString]
    def getEndpointDescriptions: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.EndpointDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("endpointDescriptions", endpointDescriptions)
    def getEndpointGroupArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupArn", endpointGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsResponse
  ) extends zio.aws.globalaccelerator.model.AddEndpointsResponse.ReadOnly {
    override val endpointDescriptions: Optional[
      List[zio.aws.globalaccelerator.model.EndpointDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.EndpointDescription.wrap(item)
        }.toList
      )
    override val endpointGroupArn: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointGroupArn())
        .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsResponse
  ): zio.aws.globalaccelerator.model.AddEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
