package zio.aws.globalaccelerator.model
import zio.aws.globalaccelerator.model.primitives.{GenericString, MaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingAcceleratorsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest = {
    import ListCustomRoutingAcceleratorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest
      .wrap(buildAwsValue())
}
object ListCustomRoutingAcceleratorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest =
      zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[GenericString]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest
  ): zio.aws.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest.ReadOnly =
    new Wrapper(impl)
}
