package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DeleteCustomRoutingEndpointGroupRequest(
    endpointGroupArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest = {
    import DeleteCustomRoutingEndpointGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest
      .builder()
      .endpointGroupArn(endpointGroupArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest
      .wrap(buildAwsValue())
}
object DeleteCustomRoutingEndpointGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest =
      zio.aws.globalaccelerator.model
        .DeleteCustomRoutingEndpointGroupRequest(endpointGroupArn)
    def endpointGroupArn: GenericString
    def getEndpointGroupArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest
  ) extends zio.aws.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest.ReadOnly {
    override val endpointGroupArn: GenericString =
      impl.endpointGroupArn(): GenericString
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest
  ): zio.aws.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest.ReadOnly =
    new Wrapper(impl)
}
