package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCustomRoutingAcceleratorResponse(
    accelerator: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingAccelerator
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse = {
    import DescribeCustomRoutingAcceleratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse
      .builder()
      .optionallyWith(accelerator.map(value => value.buildAwsValue()))(
        _.accelerator
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse
      .wrap(buildAwsValue())
}
object DescribeCustomRoutingAcceleratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse =
      zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse(
        accelerator.map(value => value.asEditable)
      )
    def accelerator: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
    ]
    def getAccelerator: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
    ] = AwsError.unwrapOptionField("accelerator", accelerator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse
  ) extends zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse.ReadOnly {
    override val accelerator: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accelerator())
      .map(value =>
        zio.aws.globalaccelerator.model.CustomRoutingAccelerator.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse
  ): zio.aws.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse.ReadOnly =
    new Wrapper(impl)
}
