package zio.aws.globalaccelerator.model
import zio.aws.globalaccelerator.model.primitives.{Timestamp, GenericString}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AcceleratorEvent(
    message: Optional[GenericString] = Optional.Absent,
    timestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.AcceleratorEvent = {
    import AcceleratorEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.AcceleratorEvent
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.AcceleratorEvent.ReadOnly =
    zio.aws.globalaccelerator.model.AcceleratorEvent.wrap(buildAwsValue())
}
object AcceleratorEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.AcceleratorEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.AcceleratorEvent =
      zio.aws.globalaccelerator.model.AcceleratorEvent(
        message.map(value => value),
        timestamp.map(value => value)
      )
    def message: Optional[GenericString]
    def timestamp: Optional[Timestamp]
    def getMessage: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("message", message)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AcceleratorEvent
  ) extends zio.aws.globalaccelerator.model.AcceleratorEvent.ReadOnly {
    override val message: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: GenericString)
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.globalaccelerator.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AcceleratorEvent
  ): zio.aws.globalaccelerator.model.AcceleratorEvent.ReadOnly = new Wrapper(
    impl
  )
}
