package zio.aws.globalaccelerator.model
import scala.jdk.CollectionConverters._
sealed trait CustomRoutingAcceleratorStatus {
  def unwrap: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorStatus
}
object CustomRoutingAcceleratorStatus {
  def wrap(
      value: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorStatus
  ): zio.aws.globalaccelerator.model.CustomRoutingAcceleratorStatus =
    value match {
      case software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorStatus.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorStatus.DEPLOYED =>
        val r = DEPLOYED
        r
      case software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorStatus.IN_PROGRESS =>
        val r = IN_PROGRESS
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.globalaccelerator.model.CustomRoutingAcceleratorStatus {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorStatus =
      software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DEPLOYED
      extends zio.aws.globalaccelerator.model.CustomRoutingAcceleratorStatus {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorStatus =
      software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorStatus.DEPLOYED
  }
  case object IN_PROGRESS
      extends zio.aws.globalaccelerator.model.CustomRoutingAcceleratorStatus {
    override def unwrap
        : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorStatus =
      software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorStatus.IN_PROGRESS
  }
}
