package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.{
  IdempotencyToken,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class CreateListenerRequest(
    acceleratorArn: GenericString,
    portRanges: Iterable[zio.aws.globalaccelerator.model.PortRange],
    protocol: zio.aws.globalaccelerator.model.Protocol,
    clientAffinity: Optional[zio.aws.globalaccelerator.model.ClientAffinity] =
      Optional.Absent,
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest = {
    import CreateListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest
      .builder()
      .acceleratorArn(acceleratorArn: java.lang.String)
      .portRanges(portRanges.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .protocol(protocol.unwrap)
      .optionallyWith(clientAffinity.map(value => value.unwrap))(
        _.clientAffinity
      )
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CreateListenerRequest.ReadOnly =
    zio.aws.globalaccelerator.model.CreateListenerRequest.wrap(buildAwsValue())
}
object CreateListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.CreateListenerRequest =
      zio.aws.globalaccelerator.model.CreateListenerRequest(
        acceleratorArn,
        portRanges.map { item =>
          item.asEditable
        },
        protocol,
        clientAffinity.map(value => value),
        idempotencyToken
      )
    def acceleratorArn: GenericString
    def portRanges: List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]
    def protocol: zio.aws.globalaccelerator.model.Protocol
    def clientAffinity: Optional[zio.aws.globalaccelerator.model.ClientAffinity]
    def idempotencyToken: IdempotencyToken
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
    def getPortRanges: ZIO[Any, Nothing, List[
      zio.aws.globalaccelerator.model.PortRange.ReadOnly
    ]] = ZIO.succeed(portRanges)
    def getProtocol
        : ZIO[Any, Nothing, zio.aws.globalaccelerator.model.Protocol] =
      ZIO.succeed(protocol)
    def getClientAffinity
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.ClientAffinity] =
      AwsError.unwrapOptionField("clientAffinity", clientAffinity)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest
  ) extends zio.aws.globalaccelerator.model.CreateListenerRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      impl.acceleratorArn(): GenericString
    override val portRanges
        : List[zio.aws.globalaccelerator.model.PortRange.ReadOnly] = impl
      .portRanges()
      .asScala
      .map { item =>
        zio.aws.globalaccelerator.model.PortRange.wrap(item)
      }
      .toList
    override val protocol: zio.aws.globalaccelerator.model.Protocol =
      zio.aws.globalaccelerator.model.Protocol.wrap(impl.protocol())
    override val clientAffinity
        : Optional[zio.aws.globalaccelerator.model.ClientAffinity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientAffinity())
        .map(value =>
          zio.aws.globalaccelerator.model.ClientAffinity.wrap(value)
        )
    override val idempotencyToken: IdempotencyToken =
      zio.aws.globalaccelerator.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest
  ): zio.aws.globalaccelerator.model.CreateListenerRequest.ReadOnly =
    new Wrapper(impl)
}
