package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCustomRoutingEndpointGroupResponse(
    endpointGroup: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse = {
    import CreateCustomRoutingEndpointGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse
      .builder()
      .optionallyWith(endpointGroup.map(value => value.buildAwsValue()))(
        _.endpointGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse.ReadOnly =
    zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse
      .wrap(buildAwsValue())
}
object CreateCustomRoutingEndpointGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse =
      zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse(
        endpointGroup.map(value => value.asEditable)
      )
    def endpointGroup: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly
    ]
    def getEndpointGroup: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly
    ] = AwsError.unwrapOptionField("endpointGroup", endpointGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse
  ) extends zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse.ReadOnly {
    override val endpointGroup: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointGroup())
      .map(value =>
        zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse
  ): zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse.ReadOnly =
    new Wrapper(impl)
}
