package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingPortMappingsByDestinationResponse(
    destinationPortMappings: Optional[
      Iterable[zio.aws.globalaccelerator.model.DestinationPortMapping]
    ] = Optional.Absent,
    nextToken: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse = {
    import ListCustomRoutingPortMappingsByDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
      .builder()
      .optionallyWith(
        destinationPortMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationPortMappings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
      .wrap(buildAwsValue())
}
object ListCustomRoutingPortMappingsByDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse =
      zio.aws.globalaccelerator.model
        .ListCustomRoutingPortMappingsByDestinationResponse(
          destinationPortMappings.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def destinationPortMappings: Optional[
      List[zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly]
    ]
    def nextToken: Optional[GenericString]
    def getDestinationPortMappings: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "destinationPortMappings",
      destinationPortMappings
    )
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse.ReadOnly {
    override val destinationPortMappings: Optional[
      List[zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationPortMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.DestinationPortMapping.wrap(item)
        }.toList
      )
    override val nextToken: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
  ): zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
