package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListEndpointGroupsResponse(
    endpointGroups: Optional[
      Iterable[zio.aws.globalaccelerator.model.EndpointGroup]
    ] = Optional.Absent,
    nextToken: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse = {
    import ListEndpointGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse
      .builder()
      .optionallyWith(
        endpointGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointGroups)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListEndpointGroupsResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListEndpointGroupsResponse
      .wrap(buildAwsValue())
}
object ListEndpointGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.ListEndpointGroupsResponse =
      zio.aws.globalaccelerator.model.ListEndpointGroupsResponse(
        endpointGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def endpointGroups
        : Optional[List[zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly]]
    def nextToken: Optional[GenericString]
    def getEndpointGroups: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("endpointGroups", endpointGroups)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse
  ) extends zio.aws.globalaccelerator.model.ListEndpointGroupsResponse.ReadOnly {
    override val endpointGroups: Optional[
      List[zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.EndpointGroup.wrap(item)
        }.toList
      )
    override val nextToken: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse
  ): zio.aws.globalaccelerator.model.ListEndpointGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
