package zio.aws.globalaccelerator.model
import zio.aws.globalaccelerator.model.primitives.{GenericString, PortNumber}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PortMapping(
    acceleratorPort: Optional[PortNumber] = Optional.Absent,
    endpointGroupArn: Optional[GenericString] = Optional.Absent,
    endpointId: Optional[GenericString] = Optional.Absent,
    destinationSocketAddress: Optional[
      zio.aws.globalaccelerator.model.SocketAddress
    ] = Optional.Absent,
    protocols: Optional[
      Iterable[zio.aws.globalaccelerator.model.CustomRoutingProtocol]
    ] = Optional.Absent,
    destinationTrafficState: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.PortMapping = {
    import PortMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.PortMapping
      .builder()
      .optionallyWith(
        acceleratorPort.map(value => PortNumber.unwrap(value): Integer)
      )(_.acceleratorPort)
      .optionallyWith(endpointGroupArn.map(value => value: java.lang.String))(
        _.endpointGroupArn
      )
      .optionallyWith(endpointId.map(value => value: java.lang.String))(
        _.endpointId
      )
      .optionallyWith(
        destinationSocketAddress.map(value => value.buildAwsValue())
      )(_.destinationSocketAddress)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .optionallyWith(destinationTrafficState.map(value => value.unwrap))(
        _.destinationTrafficState
      )
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.PortMapping.ReadOnly =
    zio.aws.globalaccelerator.model.PortMapping.wrap(buildAwsValue())
}
object PortMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.PortMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.PortMapping =
      zio.aws.globalaccelerator.model.PortMapping(
        acceleratorPort.map(value => value),
        endpointGroupArn.map(value => value),
        endpointId.map(value => value),
        destinationSocketAddress.map(value => value.asEditable),
        protocols.map(value => value),
        destinationTrafficState.map(value => value)
      )
    def acceleratorPort: Optional[PortNumber]
    def endpointGroupArn: Optional[GenericString]
    def endpointId: Optional[GenericString]
    def destinationSocketAddress
        : Optional[zio.aws.globalaccelerator.model.SocketAddress.ReadOnly]
    def protocols
        : Optional[List[zio.aws.globalaccelerator.model.CustomRoutingProtocol]]
    def destinationTrafficState: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ]
    def getAcceleratorPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("acceleratorPort", acceleratorPort)
    def getEndpointGroupArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupArn", endpointGroupArn)
    def getEndpointId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointId", endpointId)
    def getDestinationSocketAddress: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.SocketAddress.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationSocketAddress",
      destinationSocketAddress
    )
    def getProtocols: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CustomRoutingProtocol
    ]] = AwsError.unwrapOptionField("protocols", protocols)
    def getDestinationTrafficState: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ] = AwsError.unwrapOptionField(
      "destinationTrafficState",
      destinationTrafficState
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.PortMapping
  ) extends zio.aws.globalaccelerator.model.PortMapping.ReadOnly {
    override val acceleratorPort: Optional[PortNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorPort())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.PortNumber(value)
      )
    override val endpointGroupArn: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointGroupArn())
        .map(value => value: GenericString)
    override val endpointId: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointId())
      .map(value => value: GenericString)
    override val destinationSocketAddress
        : Optional[zio.aws.globalaccelerator.model.SocketAddress.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationSocketAddress())
        .map(value => zio.aws.globalaccelerator.model.SocketAddress.wrap(value))
    override val protocols: Optional[
      List[zio.aws.globalaccelerator.model.CustomRoutingProtocol]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.protocols())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.CustomRoutingProtocol.wrap(item)
        }.toList
      )
    override val destinationTrafficState: Optional[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationTrafficState())
      .map(value =>
        zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.PortMapping
  ): zio.aws.globalaccelerator.model.PortMapping.ReadOnly = new Wrapper(impl)
}
