package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingPortMappingsResponse(
    portMappings: Optional[
      Iterable[zio.aws.globalaccelerator.model.PortMapping]
    ] = Optional.Absent,
    nextToken: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse = {
    import ListCustomRoutingPortMappingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse
      .builder()
      .optionallyWith(
        portMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portMappings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsResponse
      .wrap(buildAwsValue())
}
object ListCustomRoutingPortMappingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsResponse =
      zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsResponse(
        portMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def portMappings
        : Optional[List[zio.aws.globalaccelerator.model.PortMapping.ReadOnly]]
    def nextToken: Optional[GenericString]
    def getPortMappings: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.PortMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("portMappings", portMappings)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsResponse.ReadOnly {
    override val portMappings
        : Optional[List[zio.aws.globalaccelerator.model.PortMapping.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.PortMapping.wrap(item)
          }.toList
        )
    override val nextToken: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse
  ): zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsResponse.ReadOnly =
    new Wrapper(impl)
}
