package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.globalaccelerator.model.primitives.{
  GenericString,
  GenericBoolean
}
import scala.jdk.CollectionConverters._
final case class AcceleratorAttributes(
    flowLogsEnabled: Optional[GenericBoolean] = Optional.Absent,
    flowLogsS3Bucket: Optional[GenericString] = Optional.Absent,
    flowLogsS3Prefix: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.AcceleratorAttributes = {
    import AcceleratorAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.AcceleratorAttributes
      .builder()
      .optionallyWith(flowLogsEnabled.map(value => value: java.lang.Boolean))(
        _.flowLogsEnabled
      )
      .optionallyWith(flowLogsS3Bucket.map(value => value: java.lang.String))(
        _.flowLogsS3Bucket
      )
      .optionallyWith(flowLogsS3Prefix.map(value => value: java.lang.String))(
        _.flowLogsS3Prefix
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.AcceleratorAttributes.ReadOnly =
    zio.aws.globalaccelerator.model.AcceleratorAttributes.wrap(buildAwsValue())
}
object AcceleratorAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.AcceleratorAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.AcceleratorAttributes =
      zio.aws.globalaccelerator.model.AcceleratorAttributes(
        flowLogsEnabled.map(value => value),
        flowLogsS3Bucket.map(value => value),
        flowLogsS3Prefix.map(value => value)
      )
    def flowLogsEnabled: Optional[GenericBoolean]
    def flowLogsS3Bucket: Optional[GenericString]
    def flowLogsS3Prefix: Optional[GenericString]
    def getFlowLogsEnabled: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField("flowLogsEnabled", flowLogsEnabled)
    def getFlowLogsS3Bucket: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("flowLogsS3Bucket", flowLogsS3Bucket)
    def getFlowLogsS3Prefix: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("flowLogsS3Prefix", flowLogsS3Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AcceleratorAttributes
  ) extends zio.aws.globalaccelerator.model.AcceleratorAttributes.ReadOnly {
    override val flowLogsEnabled: Optional[GenericBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowLogsEnabled())
        .map(value => value: GenericBoolean)
    override val flowLogsS3Bucket: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowLogsS3Bucket())
        .map(value => value: GenericString)
    override val flowLogsS3Prefix: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowLogsS3Prefix())
        .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AcceleratorAttributes
  ): zio.aws.globalaccelerator.model.AcceleratorAttributes.ReadOnly =
    new Wrapper(impl)
}
